<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%product}}`.
 */
class m260218_171908_create_product_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('product', [
            'id' => $this->primaryKey(),
            'category_id' => $this->integer()->notNull(),
            'name' => $this->string()->notNull(),
        ]);

        $this->addForeignKey('fk_product_category', 'product', 'category_id', 'category', 'id', 'CASCADE');

        // Вставляем товары согласно ТЗ
        $categories = (new \yii\db\Query())->select(['id', 'name'])->from('category')->all();
        $catMap = [];
        foreach ($categories as $cat) {
            $catMap[$cat['name']] = $cat['id'];
        }

        $products = [
            ['Молочная продукция', ['Молоко', 'Сметана', 'Сыр', 'Масло', 'Творог', 'Сливки']],
            ['Мясная продукция', ['Свинина', 'Говядина', 'Курица', 'Индейка', 'Утка']],
            ['Варенье', ['Малина', 'Смородина', 'Клубника', 'Яблоко', 'Груша']],
            ['Мёд', ['Разнотравье', 'Липа', 'Акация', 'Донник', 'Гречка', 'Подсолнух']],
            ['Овощи', ['Картофель', 'Капуста', 'Морковь', 'Лук', 'Свекла']],
            ['Фрукты', ['Яблоки', 'Груши']],
        ];

        foreach ($products as $item) {
            $catId = $catMap[$item[0]];
            foreach ($item[1] as $productName) {
                $this->insert('product', [
                    'category_id' => $catId,
                    'name' => $productName,
                ]);
            }
        }
    }

    public function safeDown()
    {
        $this->dropTable('product');
    }
}