<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%order}}`.
 */
class m260218_171921_create_order_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('order', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'category_id' => $this->integer()->notNull(),
            'product_id' => $this->integer()->notNull(),
            'quantity' => $this->integer()->notNull(),
            'delivery_date' => $this->date()->notNull(),
            'delivery_address' => $this->string()->notNull(),
            'payment_method' => "ENUM('cash','transfer') NOT NULL",
            'comment' => $this->text(),
            'status' => "ENUM('new','accepted','completed') DEFAULT 'new'",
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        $this->addForeignKey('fk_order_user', 'order', 'user_id', 'user', 'id', 'CASCADE');
        $this->addForeignKey('fk_order_category', 'order', 'category_id', 'category', 'id');
        $this->addForeignKey('fk_order_product', 'order', 'product_id', 'product', 'id');
    }

    public function safeDown()
    {
        $this->dropTable('order');
    }
}