<?php
use yii\helpers\Html;
use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
    <!DOCTYPE html>
    <html lang="<?= Yii::$app->language ?>">
    <head>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?></title>
        <?php $this->head() ?>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:opsz@14..32&display=swap" rel="stylesheet">
        <style>
            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }

            body {
                font-family: 'Inter', Arial, sans-serif;
                background: #f9fafc;
                display: flex;
                flex-direction: column;
                min-height: 100vh;
                color: #1e293b;
                line-height: 1.5;
            }

            .wrap {
                flex: 1;
                width: 100%;
                max-width: 1280px;
                margin: 0 auto;
                padding: 40px 30px;
            }

            header {
                background: #ffffff;
                border-bottom: 1px solid #e2e8f0;
                width: 100%;
            }

            .header-container {
                max-width: 1280px;
                margin: 0 auto;
                padding: 16px 30px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                flex-wrap: wrap;
                gap: 20px;
            }

            .logo a {
                font-weight: 700;
                font-size: 1.6rem;
                color: #2e7d32;
                text-decoration: none;
                letter-spacing: -0.02em;
            }

            nav {
                flex: 1;
                display: flex;
                justify-content: center;
                gap: 32px;
            }

            nav a {
                color: #334155;
                text-decoration: none;
                font-weight: 500;
                transition: color 0.2s;
            }

            nav a:hover {
                color: #2e7d32;
            }

            .user-menu {
                display: flex;
                align-items: center;
                gap: 16px;
            }

            .btn-logout {
                background: transparent;
                border: 1px solid #cbd5e1;
                padding: 6px 18px;
                border-radius: 40px;
                font-size: 0.95rem;
                color: #475569;
                cursor: pointer;
                transition: all 0.2s;
            }

            .btn-logout:hover {
                background: #f1f5f9;
                border-color: #94a3b8;
            }

            h1, h2, h3 {
                color: #2e7d32;
                font-weight: 600;
                letter-spacing: -0.02em;
            }

            h1 { font-size: 2.5rem; margin-bottom: 0.75rem; }
            h2 { font-size: 2rem; margin-bottom: 1.5rem; }

            .btn {
                display: inline-block;
                padding: 12px 28px;
                background: #2e7d32;
                color: white;
                text-decoration: none;
                border: none;
                border-radius: 40px;
                cursor: pointer;
                font-size: 1rem;
                font-weight: 500;
                transition: background 0.2s;
            }

            .btn:hover {
                background: #1b5e20;
            }

            .btn-outline {
                background: transparent;
                color: #2e7d32;
                border: 2px solid #2e7d32;
            }

            .btn-outline:hover {
                background: #e8f5e9;
            }

            .form-group {
                margin-bottom: 24px;
            }

            label {
                display: block;
                margin-bottom: 6px;
                font-weight: 500;
                color: #334155;
            }

            input[type="text"],
            input[type="email"],
            input[type="password"],
            input[type="date"],
            select,
            textarea {
                width: 100%;
                max-width: 420px;
                padding: 12px 16px;
                border: 1px solid #cbd5e1;
                border-radius: 16px;
                font-family: inherit;
                font-size: 1rem;
                transition: border-color 0.2s;
                background: #ffffff;
            }

            input:focus,
            select:focus,
            textarea:focus {
                outline: none;
                border-color: #2e7d32;
            }

            select {
                width: auto;
                min-width: 260px;
                background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 24 24' fill='none' stroke='%23334155' stroke-width='2'%3E%3Cpolyline points='6 9 12 15 18 9'%3E%3C/polyline%3E%3C/svg%3E");
                background-repeat: no-repeat;
                background-position: right 16px center;
                appearance: none;
            }

            .error-message {
                color: #d32f2f;
                font-size: 0.9rem;
                margin-top: 6px;
            }

            table {
                width: 100%;
                border-collapse: collapse;
                border: 1px solid #e9edf2;
                border-radius: 20px;
                overflow: hidden;
                font-size: 0.95rem;
            }

            th, td {
                text-align: left;
                padding: 14px 16px;
                border-bottom: 1px solid #e9edf2;
            }

            th {
                background: #f8fafc;
                font-weight: 600;
                color: #2e7d32;
            }

            tr:last-child td {
                border-bottom: none;
            }

            /* Адаптация таблицы без прокрутки */
            @media (max-width: 800px) {
                th, td {
                    padding: 10px 8px;
                    font-size: 0.85rem;
                }
            }

            @media (max-width: 600px) {
                th:nth-child(8), td:nth-child(8),  /* Пожелания */
                th:nth-child(7), td:nth-child(7) { /* Способ оплаты */
                    display: none;
                }
            }

            @media (max-width: 480px) {
                th:nth-child(6), td:nth-child(6) { /* Адрес доставки */
                    display: none;
                }
            }

            .banner {
                background: linear-gradient(135deg, #2e7d32 0%, #4caf50 100%);
                border-radius: 32px;
                padding: 60px 50px;
                color: white;
                margin-bottom: 50px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                flex-wrap: wrap;
                gap: 30px;
            }

            .banner-content {
                max-width: 600px;
            }

            .banner h1 {
                color: white;
                font-size: 3rem;
                margin-bottom: 20px;
                line-height: 1.2;
            }

            .banner p {
                font-size: 1.2rem;
                opacity: 0.9;
                margin-bottom: 30px;
            }

            .banner .btn {
                background: white;
                color: #2e7d32;
            }

            footer {
                border-top: 1px solid #e2e8f0;
                text-align: center;
                padding: 24px;
                color: #64748b;
                font-size: 0.95rem;
                background: #ffffff;
            }
            /* Внутри <style> */
            .page-header {
                display: flex;
                align-items: center;
                justify-content: space-between;
                flex-wrap: wrap;
                gap: 20px;
                margin-bottom: 30px;
            }

            .page-header h1 {
                margin-bottom: 0;
            }

            .btn {
                /* уже есть */
                color: white; /* явно зададим */
            }

            .btn:hover {
                background: #1b5e20;
                color: white; /* чтобы текст не темнел */
            }

            .btn-outline:hover {
                background: #e8f5e9;
                color: #1b5e20; /* для outline оставим зелёный, но он читаем */
            }
            input[type="number"],  /* добавьте эту строку */
            select,
            textarea {
                max-width: 420px;
            }

            @media (max-width: 768px) {
                .header-container {
                    flex-direction: column;
                    align-items: stretch;
                }
                nav {
                    justify-content: flex-start;
                }
                .user-menu {
                    justify-content: flex-end;
                }
                .banner { padding: 40px 24px; text-align: center; }
                .banner h1 { font-size: 2.2rem; }
            }

        </style>
    </head>
    <body>
    <?php $this->beginBody() ?>

    <header>
        <div class="header-container">
            <div class="logo">
                <a href="/">Эко еда</a>
            </div>
            <nav>
                <?php if (Yii::$app->user->isGuest): ?>
                    <a href="<?= \yii\helpers\Url::to(['site/login']) ?>">Вход</a>
                    <a href="<?= \yii\helpers\Url::to(['site/register']) ?>">Регистрация</a>
                <?php else: ?>
                    <a href="<?= \yii\helpers\Url::to(['site/orders']) ?>">Мои заявки</a>
                    <?php if (Yii::$app->user->identity->role === 'admin'): ?>
                        <a href="<?= \yii\helpers\Url::to(['site/admin']) ?>">Админка</a>
                    <?php endif; ?>
                <?php endif; ?>
            </nav>
            <div class="user-menu">
                <?php if (!Yii::$app->user->isGuest): ?>
                    <?= Html::beginForm(['/site/logout'], 'post') ?>
                    <?= Html::submitButton('Выйти', ['class' => 'btn-logout']) ?>
                    <?= Html::endForm() ?>
                <?php endif; ?>
            </div>
        </div>
    </header>

    <div class="wrap">
        <?= $content ?>
    </div>

    <footer>
        &copy; Эко еда, <?= date('Y') ?>
    </footer>

    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>