<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Административная панель';
?>

    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h1>Все заявки</h1>
        <!-- Здесь можно что-то добавить, но пока оставим пусто -->
    </div>

<?php if (empty($orders)): ?>
    <p>Заявок пока нет.</p>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>ID</th>
            <th>Пользователь</th>
            <th>Товар</th>
            <th>Кол-во</th>
            <th>Дата доставки</th>
            <th>Статус</th>
            <th>Действия</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($orders as $order): ?>
            <tr>
                <td><?= $order->id ?></td>
                <td><?= Html::encode($order->user->full_name) ?><br><?= $order->user->phone ?></td>
                <td><?= Html::encode($order->product->name) ?></td>
                <td><?= $order->quantity ?></td>
                <td><?= Yii::$app->formatter->asDate($order->delivery_date, 'dd MMM yyyy') ?></td>
                <td>
                    <?= Html::beginForm(['site/admin'], 'post', ['style' => 'display:inline;']) ?>
                    <?= Html::hiddenInput('order_id', $order->id) ?>
                    <?= Html::dropDownList('status', $order->status, [
                        'new' => 'Новая',
                        'accepted' => 'Принят',
                        'completed' => 'Завершён',
                    ], ['style' => 'padding: 4px;']) ?>
                    <?= Html::submitButton('Изменить', ['class' => 'btn', 'style' => 'padding: 4px 10px; margin-left: 5px;']) ?>
                    <?= Html::endForm() ?>
                </td>
                <td>
                    <?= Html::a('Просмотр', ['view-order', 'id' => $order->id], ['class' => 'btn', 'style' => 'padding: 6px 12px; font-size: 0.9rem;']) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>