<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\widgets\MaskedInput;

$this->title = 'Регистрация';
?>
<h1>Регистрация</h1>

<?php $form = ActiveForm::begin(['id' => 'register-form']); ?>

<?= $form->field($model, 'full_name')->textInput(['autofocus' => true]) ?>

<?= $form->field($model, 'phone')->widget(MaskedInput::class, [
    'mask' => '8(999)999-99-99',
]) ?>

<?= $form->field($model, 'email')->input('email') ?>

<?= $form->field($model, 'password')->passwordInput() ?>

<?= $form->field($model, 'password_repeat')->passwordInput() ?>

<?= $form->field($model, 'agree')->checkbox(['label' => 'Я согласен с правилами регистрации']) ?>

<div class="form-group">
    <?= Html::submitButton('Создать пользователя', ['class' => 'btn']) ?>
</div>

<?php ActiveForm::end(); ?>

<p>Уже зарегистрированы? <?= Html::a('Войти', ['login']) ?></p>