<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Заявка #' . $order->id;
?>
<div class="page-header">
    <h1>Заявка #<?= $order->id ?></h1>
    <a href="<?= Url::previous() ?>" class="btn">Назад</a>
</div>

<table style="max-width: 600px;">
    <tr>
        <th>Категория</th>
        <td><?= Html::encode($order->category->name) ?></td>
    </tr>
    <tr>
        <th>Товар</th>
        <td><?= Html::encode($order->product->name) ?></td>
    </tr>
    <tr>
        <th>Количество</th>
        <td><?= $order->quantity ?></td>
    </tr>
    <tr>
        <th>Дата доставки</th>
        <td><?= Yii::$app->formatter->asDate($order->delivery_date, 'dd MMM yyyy') ?></td>
    </tr>
    <tr>
        <th>Адрес доставки</th>
        <td><?= Html::encode($order->delivery_address) ?></td>
    </tr>
    <tr>
        <th>Способ оплаты</th>
        <td><?= $order->payment_method === 'cash' ? 'Наличные' : 'Перевод по телефону' ?></td>
    </tr>
    <?php if ($order->comment): ?>
        <tr>
            <th>Пожелания</th>
            <td><?= Html::encode($order->comment) ?></td>
        </tr>
    <?php endif; ?>
    <tr>
        <th>Статус</th>
        <td>
            <?php
            $statusLabels = [
                'new' => 'Новая',
                'accepted' => 'Заказ принят',
                'completed' => 'Заказ завершён',
            ];
            echo $statusLabels[$order->status] ?? $order->status;
            ?>
        </td>
    </tr>
    <tr>
        <th>Дата создания</th>
        <td><?= Yii::$app->formatter->asDatetime($order->created_at, 'dd MMM yyyy, HH:mm') ?></td>
    </tr>
</table>